/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.entities;

import dangerzone.BreakChecks;
import dangerzone.DangerZone;
import dangerzone.InventoryContainer;
import dangerzone.Player;
import dangerzone.TextureMapper;
import dangerzone.World;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.threads.LightingThread;
import java.util.List;
import java.util.ListIterator;
import org.newdawn.slick.opengl.Texture;

public class EntityFire
extends Entity {
    public Texture texturetb;
    private int seq = 0;
    private int sides = 0;
    private int mybt = 0;
    private short[][][] firesave = null;
    private int lightingticker = 300;
    private int adjusted_sides;
    public Entity started_by = null;
    public boolean diefast = false;

    public EntityFire(World w) {
        super(w);
        this.uniquename = "DangerZone:Fire";
        this.ignoreCollisions = true;
        this.width = 1.125f;
        this.height = 1.125f;
        this.firesave = new short[3][4][3];
        this.setBID(0);
    }

    @Override
    public void update(float deltaT) {
        int ts = 0;
        boolean islava = false;
        this.motionz = 0.0f;
        this.motiony = 0.0f;
        this.motionx = 0.0f;
        this.rotation_roll = 0.0f;
        this.rotation_yaw = 0.0f;
        this.rotation_pitch = 0.0f;
        int bid = this.world.getblock(this.dimension, (int)this.posx + 1, (int)this.posy + 1, (int)this.posz);
        if (bid == 0 || bid == Blocks.lava.blockID) {
            ts |= 1;
        }
        if (bid == Blocks.lava.blockID) {
            islava = true;
        }
        if ((bid = this.world.getblock(this.dimension, (int)this.posx - 1, (int)this.posy + 1, (int)this.posz)) == 0 || bid == Blocks.lava.blockID) {
            ts |= 2;
        }
        if (bid == Blocks.lava.blockID) {
            islava = true;
        }
        if ((bid = this.world.getblock(this.dimension, (int)this.posx, (int)this.posy + 1, (int)this.posz + 1)) == 0 || bid == Blocks.lava.blockID) {
            ts |= 4;
        }
        if (bid == Blocks.lava.blockID) {
            islava = true;
        }
        if ((bid = this.world.getblock(this.dimension, (int)this.posx, (int)this.posy + 1, (int)this.posz - 1)) == 0 || bid == Blocks.lava.blockID) {
            ts |= 8;
        }
        if (bid == Blocks.lava.blockID) {
            islava = true;
        }
        if ((bid = this.world.getblock(this.dimension, (int)this.posx, (int)this.posy + 2, (int)this.posz)) == 0 || bid == Blocks.lava.blockID) {
            ts |= 0x10;
        }
        if (bid == Blocks.lava.blockID) {
            islava = true;
        }
        if ((bid = this.world.getblock(this.dimension, (int)this.posx, (int)this.posy, (int)this.posz)) == 0 || bid == Blocks.lava.blockID) {
            ts |= 0x20;
        }
        if (bid == Blocks.lava.blockID) {
            islava = true;
        }
        this.sides = ts;
        if (this.sides == 0 && !islava) {
            this.deadflag = true;
        }
        if (!this.world.isServer) {
            ++this.lightingticker;
            if (this.lightingticker > 300) {
                this.lightingticker = this.world.rand.nextInt(150);
                LightingThread.addRequest(this.dimension, (int)this.posx, (int)(this.posy + 1.0), (int)this.posz, 0.65f);
            }
        } else {
            ++this.mybt;
            if (!this.diefast && !BreakChecks.fireDamage(this.started_by != null ? this.started_by : this, this.dimension, (int)this.posx, (int)this.posy + 1, (int)this.posz)) {
                this.diefast = true;
            }
            int bt = Blocks.getBurnTime(this.world.getblock(this.dimension, (int)this.posx, (int)this.posy + 1, (int)this.posz));
            if ((!DangerZone.start_client || this.diefast) && bt > 4) {
                bt = (int)Math.sqrt(bt);
            }
            if (this.mybt > bt) {
                if (bt > 0 && !this.diefast) {
                    this.world.setblockWithPerm(this.started_by != null ? this.started_by : this, this.dimension, (int)this.posx, (int)this.posy + 1, (int)this.posz, 0);
                }
                this.deadflag = true;
            }
            int i = -1;
            while (i <= 1) {
                int j = 0;
                while (j <= 3) {
                    int k = -1;
                    while (k <= 1) {
                        if ((i != 0 || j != 0 || k != 0) && this.firesave[i + 1][j][k + 1] == 0 && (bt = Blocks.getBurnTime(this.world.getblock(this.dimension, (int)this.posx + i, (int)this.posy + j, (int)this.posz + k))) > 0) {
                            int btuse = bt;
                            if (bt > 10000) {
                                btuse = 10000;
                            }
                            if (this.world.rand.nextInt(btuse + 1 + this.getBID()) == 0) {
                                List<Entity> nearby_list = null;
                                Entity e = null;
                                boolean hasfire = false;
                                nearby_list = DangerZone.server.entityManager.findALLEntitiesInRange(4.0f, this.dimension, (int)this.posx + i, (int)this.posy + j, (int)this.posz + k);
                                if (nearby_list != null && !nearby_list.isEmpty()) {
                                    ListIterator<Entity> li = nearby_list.listIterator();
                                    while (li.hasNext()) {
                                        e = li.next();
                                        if (e instanceof EntityFire) {
                                            if (!(e.posx > this.posx + (double)i - 0.5) || !(e.posx < this.posx + (double)i + 0.5) || !(e.posz > this.posz + (double)k - 0.5) || !(e.posz < this.posz + (double)k + 0.5) || !(e.posy > this.posy + (double)j - 1.5) || !(e.posy < this.posy + (double)j - 0.5)) continue;
                                            hasfire = true;
                                            this.firesave[i + 1][j][k + 1] = 1;
                                            break;
                                        }
                                        if (!(e instanceof EntityLiving)) continue;
                                        e.doSetOnFire(120);
                                    }
                                }
                                if (!hasfire) {
                                    int ix = (int)this.posx + i;
                                    int iy = (int)this.posy + j;
                                    int iz = (int)this.posz + k;
                                    EntityFire eb = (EntityFire)this.world.createEntityByName("DangerZone:Fire", this.dimension, (double)ix + 0.5, (double)iy - 0.0625, (double)iz + 0.5);
                                    if (eb != null) {
                                        eb.init();
                                        eb.started_by = this.started_by;
                                        eb.diefast = this.diefast;
                                        eb.setBID(this.getBID() + 2);
                                        if (!DangerZone.start_client || this.diefast) {
                                            eb.setBID(this.getBID() + 10);
                                        }
                                        this.world.spawnEntityInWorld(eb);
                                    }
                                    this.firesave[i + 1][j][k + 1] = 1;
                                }
                            }
                        }
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
        }
        if (this.world.rand.nextInt(5) == 0) {
            ++this.seq;
            this.seq &= 7;
        }
        this.adjusted_sides = this.sides;
        if (DangerZone.start_client && DangerZone.player != null) {
            if (DangerZone.player.posy > this.posy + 4.0) {
                this.adjusted_sides &= 0x1F;
            }
            if (DangerZone.player.posy < this.posy - 3.0) {
                this.adjusted_sides &= 0x2F;
            }
            if (DangerZone.player.posx > this.posx + 5.0) {
                this.adjusted_sides &= 0x3D;
            }
            if (DangerZone.player.posx < this.posx - 5.0) {
                this.adjusted_sides &= 0x3E;
            }
            if (DangerZone.player.posz > this.posz + 5.0) {
                this.adjusted_sides &= 0x37;
            }
            if (DangerZone.player.posz < this.posz - 5.0) {
                this.adjusted_sides &= 0x3B;
            }
        }
        super.update(deltaT);
    }

    @Override
    public boolean rightClickedByPlayer(Player p, InventoryContainer ic) {
        if (this.world.isServer && this.world.rand.nextInt(2) == 0) {
            this.deadflag = true;
        }
        return false;
    }

    @Override
    public boolean leftClickedByPlayer(Player p, InventoryContainer ic) {
        if (this.world.isServer && this.world.rand.nextInt(2) == 0) {
            this.deadflag = true;
        }
        return false;
    }

    public int gettextureSeq() {
        return this.seq;
    }

    public int getSides() {
        return this.adjusted_sides;
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("res/misc/fire_side.png");
        }
        return this.texture;
    }

    public Texture getTextureBottom() {
        if (this.texturetb == null) {
            this.texturetb = TextureMapper.getTexture("res/misc/fire_topbottom.png");
        }
        return this.texturetb;
    }
}

